<?php

function calculateLevel($experience) {
    $levels = [];
    $required_exp = 0;
    
    for ($level = 1; $level <= 50; $level++) {
        $required_exp = ($level * $level) * 10;
        $levels[$level] = [
            'level' => $level,
            'required_exp' => $required_exp,
            'title' => getLevelTitle($level)
        ];
    }
    
    return $levels;
}

function getLevelTitle($level) {
    $titles = [
        1 => 'تازه‌کار',
        2 => 'کاربر',
        3 => 'کاربر فعال',
        4 => 'کاربر پرتلاش',
        5 => 'کاربر ویژه',
        6 => 'کاربر حرفه‌ای',
        7 => 'کاربر برتر',
        8 => 'کاربر نخبه',
        9 => 'کاربر ممتاز',
        10 => 'کاربر طلایی',
        11 => 'کاربر نقره‌ای',
        12 => 'کاربر الماسی',
        13 => 'کاربر پلاتینیومی',
        14 => 'کاربر افسانه‌ای',
        15 => 'کاربر اسطوره‌ای',
        16 => 'کاربر سلطنتی',
        17 => 'کاربر امپراتور',
        18 => 'کاربر خدایگان',
        19 => 'کاربر کیهانی',
        20 => 'کاربر ابدی'
    ];
    
    if ($level <= 20) {
        return $titles[$level];
    } elseif ($level <= 30) {
        return 'کاربر کهکشانی ' . ($level - 19);
    } elseif ($level <= 40) {
        return 'کاربر کوانتومی ' . ($level - 29);
    } elseif ($level <= 50) {
        return 'کاربر متافیزیکی ' . ($level - 39);
    } else {
        return 'کاربر افسانه‌ای';
    }
}

function getUserLevelInfo($user_id, $connect) {
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT level, experience, total_experience, level_title FROM user WHERE id = '$user_id' LIMIT 1"));
    
    if (!$user) {
        return null;
    }
    
    $current_level = $user['level'];
    $current_exp = $user['experience'];
    $total_exp = $user['total_experience'];
    $levels_data = calculateLevel($current_exp);
    $next_level = $current_level + 1;
    
    if ($current_level >= 50) {
        $next_exp_needed = 0;
        $exp_for_current = $levels_data[50]['required_exp'];
        $progress_percentage = 100;
    } else {
        $exp_for_current = $levels_data[$current_level]['required_exp'];
        $exp_for_next = $levels_data[$next_level]['required_exp'];
        $next_exp_needed = $exp_for_next - $exp_for_current;
        $current_progress = $current_exp - $exp_for_current;
        
        if ($next_exp_needed > 0) {
            $progress_percentage = round(($current_progress / $next_exp_needed) * 100, 1);
        } else {
            $progress_percentage = 0;
        }
    }
    
    return [
        'current_level' => $current_level,
        'current_title' => $user['level_title'],
        'current_exp' => $current_exp,
        'total_exp' => $total_exp,
        'next_level' => $next_level,
        'next_exp_needed' => $next_exp_needed,
        'progress_percentage' => $progress_percentage,
        'exp_for_current' => $exp_for_current,
        'progress_bar' => generateProgressBar($progress_percentage)
    ];
}

function generateProgressBar($percentage, $length = 10) {
    $filled = round(($percentage / 100) * $length);
    $empty = $length - $filled;
    
    $bar = "";
    for ($i = 0; $i < $filled; $i++) {
        $bar .= "▓";
    }
    for ($i = 0; $i < $empty; $i++) {
        $bar .= "░";
    }
    
    return $bar;
}

function addExperience($user_id, $exp_amount, $reason, $connect) {
    $user = mysqli_fetch_assoc(mysqli_query($connect, "SELECT level, experience, total_experience FROM user WHERE id = '$user_id' LIMIT 1"));
    
    if (!$user) {
        return ['success' => false, 'message' => 'کاربر یافت نشد'];
    }
    
    $old_level = $user['level'];
    $old_exp = $user['experience'];
    $old_total_exp = $user['total_experience'];
    
    $new_exp = $old_exp + $exp_amount;
    $new_total_exp = $old_total_exp + $exp_amount;
    
    $levels_data = calculateLevel($new_exp);
    $new_level = $old_level;
    
    foreach ($levels_data as $level => $data) {
        if ($new_exp >= $data['required_exp']) {
            $new_level = $level;
        } else {
            break;
        }
    }
    
    mysqli_query($connect, "UPDATE user SET 
        experience = '$new_exp',
        total_experience = '$new_total_exp',
        level = '$new_level',
        level_title = '" . getLevelTitle($new_level) . "'
        WHERE id = '$user_id'");
    
    $level_up_messages = [];
    if ($new_level > $old_level) {
        for ($lvl = $old_level + 1; $lvl <= $new_level; $lvl++) {
            mysqli_query($connect, "INSERT INTO level_up_history (user_id, old_level, new_level, experience_gained) VALUES ('$user_id', '$old_level', '$lvl', '$exp_amount')");
            
            $level_reward = calculateLevelReward($lvl);
            if ($level_reward['points'] > 0) {
                mysqli_query($connect, "UPDATE user SET points = points + {$level_reward['points']} WHERE id = '$user_id'");
            }
            
            $level_up_messages[] = [
                'level' => $lvl,
                'title' => getLevelTitle($lvl),
                'reward' => $level_reward
            ];
        }
    }
    
    return [
        'success' => true,
        'old_level' => $old_level,
        'new_level' => $new_level,
        'exp_added' => $exp_amount,
        'new_exp' => $new_exp,
        'new_total_exp' => $new_total_exp,
        'leveled_up' => $new_level > $old_level,
        'level_up_messages' => $level_up_messages,
        'reason' => $reason
    ];
}

function calculateLevelReward($level) {
    $rewards = [
        'points' => $level * 10,
        'multiplier' => 1,
        'badge' => ''
    ];
    
    if ($level == 5) {
        $rewards['points'] += 50;
        $rewards['badge'] = '🌟';
    } elseif ($level == 10) {
        $rewards['points'] += 100;
        $rewards['badge'] = '💎';
        $rewards['multiplier'] = 1.1;
    } elseif ($level == 20) {
        $rewards['points'] += 200;
        $rewards['badge'] = '👑';
        $rewards['multiplier'] = 1.2;
    } elseif ($level == 30) {
        $rewards['points'] += 500;
        $rewards['badge'] = '🏆';
        $rewards['multiplier'] = 1.3;
    } elseif ($level == 40) {
        $rewards['points'] += 1000;
        $rewards['badge'] = '🚀';
        $rewards['multiplier'] = 1.5;
    } elseif ($level == 50) {
        $rewards['points'] += 5000;
        $rewards['badge'] = '⚡';
        $rewards['multiplier'] = 2;
    }
    
    return $rewards;
}